
/**
 ******************************************************************************
 *
 * @file        stdio_fput_fget_to_URT0.c
 * @brief       Replace fput routine of stdio.
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "stdio.h"
#include "string.h"
#include "MG32_URT_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static volatile uint8_t gURT4_First = 0;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


int fputc(int ch, FILE *f)
{
    ((void)(f));
    
    if(gURT4_First == 0)
        gURT4_First = 1;
    else
        while((URT4->STA.W & URT_STA_TCF_mask_w) == 0); // while(URT_GetITSingleFlagStatus(URT4, URT_IT_TC) == DRV_UnHappened);

    URT4->STA.W = URT_STA_TCF_mask_w;       // URT_ClearITFlag(URT4, URT_IT_TC);
    URT4->TDAT.B[0] = (uint8_t)ch;          // URT_SetTXData(URT4, 1, ch);
    return ch;
}



